clear;
%%% Input the total running steps here %%%
ZZ=3000; %ZZ: totol steps

%%% Input your system parameters here. If the system parameters are stored in a file, load that file. %%%
load sys_par.mat;
% A=eye(2); % A: A matrix
% C=eye(2); % C: C matrix
% W=[0.03 -0.02; -0.02 0.04]; % W: system noise covariance
% Z=[2 1;1 2]; % Z: weighting matrix
% V=zeros(2,2); % V: measurement noise covariance
% lambda=20; % lambda: communication price for one transmission
% mu_0=[0;0]; % mu_0: initial stateload sys_par.mat;
% 
% % Kalman filter design %
% X=dare(A',C',W,V);
% L=X*C'/(C*X*C'+V);
% Q=(eye(n)-L*C)*X;
% Y=L*(C*A*Q*A'*C'+C*W*C'+V)*L';

n=length(A);
% Li's Quadratic arrpoximation design
delta=sqrt(0.11);
A_tend=A/sqrt(1+delta^2);
Z_tend=Z/(1+delta^2);
H=dlyap(A_tend',Z_tend);
zeta=(delta^2*lambda+trace(H*Y))/(1+delta^2);


% Cogill's quadratic design
H2=[1.47 0.73;0.73 1.47];


% Run the system
% Initialization
R=chol(W,'lower');
W_=chol(W,'lower');
V_=sqrt(V);
x(:,1)=R*randn(n,1)+mu_0;
m=length(V);
y(:,1)=C*x(:,1)+V_*randn(m,1);
x_kf(:,1)=mu_0+L*(y(1)-C*mu_0);
x_ro_=mu_0;   % Remote state estimate using polynomial event trigger
x_ro_1_=mu_0; % Remote state estiamte using Li's quadratic event trigger
x_ro_2_=mu_0; % Remote state estiamte using Cogill's quadratic event trigger
J=0;    % Actual cost using polynomial event trigger
J1=0;   % Actual cost using Li's quadratic event trigger
J2=0;   % Actual cost using Cogill's quadratic event trigger
sam=0;  % Sample times using polynomial event trigger
sam1=0; % Sample times using Li's quadratic event trigger
sam2=0; % Sample times using Cogill's quadratic event trigger
load eve_dec.mat;

tic
for k=1:ZZ
    fprintf('Running at step %d.\n',k);
    e_kf(:,k)=x(:,k)-x_kf(:,k);
    % polynomial event trigger
    e_=x_kf(:,k)-x_ro_;
    if eve_evaluation(Ef,Ef0,lambda,e_,Z)>=0
        x_ro(:,k)=x_kf(:,k);
        J=J+lambda;
        sam=sam+1;
    else
        x_ro(:,k)=x_ro_;
    end
    % Li's quadratic event trigger
    e_1=x_kf(:,k)-x_ro_1_;
    if e_1'*H*e_1>lambda-zeta
        x_ro_1(:,k)=x_kf(:,k);
        J1=J1+lambda;
        sam1=sam1+1;
    else
        x_ro_1(:,k)=x_ro_1_;
    end
    % Cogill's quadratic event trigger
    e_2=x_kf(:,k)-x_ro_2_;
    if e_2'*H2*e_2>1
        x_ro_2(:,k)=x_kf(:,k);
        J2=J2+lambda;
        sam2=sam2+1;
    else
        x_ro_2(:,k)=x_ro_2_;
    end
    e_ro(:,k)=x(:,k)-x_ro(:,k);
    J=J+e_ro(:,k)'*Z*e_ro(:,k);
    e_ro_1(:,k)=x(:,k)-x_ro_1(:,k);
    J1=J1+e_ro_1(:,k)'*Z*e_ro_1(:,k);
    e_ro_2(:,k)=x(:,k)-x_ro_2(:,k);
    J2=J2+e_ro_2(:,k)'*Z*e_ro_2(:,k);
    % update x,y,x_kf and a priori remote state estimates for the next step.
    x(:,k+1)=A*x(:,k)+W_*randn(n,1);
    y(:,k+1)=C*x(:,k+1)+V_*randn(m,1);
    x_kf(:,k+1)=A*x_kf(:,k)+L*(y(:,k+1)-C*A*x_kf(:,k));
    x_ro_=A*x_ro(:,k);
    x_ro_1_=A*x_ro_1(:,k);
    x_ro_2_=A*x_ro_2(:,k);
end
toc
disp('             actual cost    upper bound on the cost ');
fprintf('polynomial:  %f\t\t %f\n', J/ZZ, double(J_overline));
fprintf('[20]:\t\t %f\t\t %f\n', J1/ZZ, min(trace(H*Y)+zeta,lambda)+trace(Q*Z));
fprintf('[19]:\t\t %f\t\t %f\n', J2/ZZ, 2*lambda*trace(W*H2)/(1+trace(W*H2)));
% [sam sam1 sam2]
% degree=[]; Jbar=[];J=[];E=polynomial();
% save data_poly.mat degree Jbar J E;
% load data_poly.mat;
% degree=[degree high_degree];
% Jbar=[Jbar double(Js)];
% J=[J J/ZZ];
% pvar x1 x2;
% E=[E Ef-Ef0+[x1;x2]'*Z*[x1;x2]];
% save data_poly.mat degree Jbar J E;